function CreateQuestEntitiesOutside()
	
	gvTypesToTrack = {}
	gvTypesToTrackBuildings = {}
	WallTypes = {}
	Player1Units = {}
	Player1Buildings = {}
	
	for k,v in pairs(Entities) do
        if (string.find(k, "CU_", 1, true) or string.find(k, "PU_", 1, true) or string.find(k, "PV_",1,true)) and not string.find(k, "Soldier", 1, true) and not string.find(k, "Hawk",1,true) and not string.find(k,"Hero2_",1,true)  then
            gvTypesToTrack[v] = true;
        end;
		if (string.find(k,"CB_",1,true) or string.find(k,"PB_",1,true) or string.find(k,"Hero2_",1,true)) and not string.find(k, "Bridge",1,true) then
			gvTypesToTrackBuildings[v] = true
		end
		if (string.find(k,"XD_Wall",1,true)) then
			WallTypes[v] = true
		end
    end;
	
	for _buildingtype, _ in pairs(gvTypesToTrackBuildings) do
		local p1buildings = GetAllEntitiesOfPlayerOfType(1, _buildingtype)
		for i = 1,table.getn(p1buildings) do
			Player1Buildings[p1buildings[i]] = true;
		end
	end
	
	for type, _ in pairs(gvTypesToTrack) do
		local units = GetAllEntitiesOfPlayerOfType(1, type);
		for i = 1,table.getn(units) do
		  Player1Units[units[i]] = true;
		end;
	end;
	
	WallHurterTrigger = Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_HURT_ENTITY,nil,"WallFunc",1,nil,nil)
	
	--BuildingCreatedTrigger = Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_CREATED,nil,"P1BuildingCreated",1,nil,nil)
	BuildingDestroiedTrigger = Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_DESTROYED,nil,"P1BuildingDestroied",1,nil,nil)
	
	--EntityCreatedTrigger = Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_CREATED,nil,"P1EntityCreated",1,nil,nil)
	EntityDestroiedTrigger = Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_DESTROYED,nil,"P1EntityDestroied",1,nil,nil)
	
	Trigger.RequestTrigger( Events.LOGIC_EVENT_ENTITY_CREATED, "", "EMS_RF_TowerLimit_EntityCreated", 1);
end

function WallFunc()
	local _wallID = Event.GetEntityID2()
	if Logic.EntityGetPlayer(_wallID) == 1 then	
		if WallTypes[Logic.GetEntityType(_wallID)] then
			local damage = Logic.GetEntityDamage(Event.GetEntityID1())
			if Logic.GetEntityHealth(_wallID) > 2*damage then
				Logic.HurtEntity(_wallID, damage)
			end
		end
	end
	return false
end

function GetOutsideEntitiesIn()
	EntitiesOutside = {}
	Gate1ID = "Gate1"
	Gate2ID = "Gate2"
	Gate3ID = "Gate3"
	Gate1Pos = GetPosition(Gate1ID)
	local Gate2Pos = GetPosition(Gate2ID)
	Gate3Pos = GetPosition(Gate3ID)
	local Gate1Table = {Logic.GetPlayerEntitiesInArea(1, nil, Gate1Pos.X, Gate1Pos.Y, 300, 16)}
	local Gate2Table = {Logic.GetPlayerEntitiesInArea(1, nil, Gate2Pos.X, Gate2Pos.Y, 300, 16)}
	local Gate3Table = {Logic.GetPlayerEntitiesInArea(1, nil, Gate3Pos.X, Gate3Pos.Y, 300, 16)}
	while Gate1Table[1] > 0 do
		if Logic.IsLeader(Gate1Table[2]) == 1 then
			EntitiesOutside[Gate1Table[2]] = {Type=Logic.GetEntityType(Gate1Table[2]),Number=Logic.LeaderGetNumberOfSoldiers(Gate1Table[2])}
			DestroyEntity(Gate1Table[2])
		elseif Logic.IsEntityInCategory(Gate1Table[2],EntityCategories.Soldier) == 1 then
			if not EntitiesOutside[GetLeaderOfSoldier(Gate1Table[2])] then
				EntitiesOutside[GetLeaderOfSoldier(Gate1Table[2])] = {Type=Logic.GetEntityType(GetLeaderOfSoldier(Gate1Table[2])),Number=Logic.LeaderGetNumberOfSoldiers(GetLeaderOfSoldier(Gate1Table[2]))}
				DestroyEntity(GetLeaderOfSoldier(Gate1Table[2]))
			end
		else
			if Logic.IsEntityInCategory(Gate1Table[2], EntityCategories.Worker) == 0 then
				EntitiesOutside[Gate1Table[2]] = {Type=Logic.GetEntityType(Gate1Table[2])}
				DestroyEntity(Gate1Table[2])
			else
				DestroyEntity(Gate1Table[2])
			end
		end
		Gate1Table = {Logic.GetPlayerEntitiesInArea(1, nil, Gate1Pos.X, Gate1Pos.Y, 300, 16)}
	end
	while Gate2Table[1] > 0 do
		if Logic.IsLeader(Gate2Table[2]) == 1 then
			EntitiesOutside[Gate2Table[2]] = {Type=Logic.GetEntityType(Gate2Table[2]),Number=Logic.LeaderGetNumberOfSoldiers(Gate2Table[2])}
			DestroyEntity(Gate2Table[2])
		elseif Logic.IsEntityInCategory(Gate2Table[2],EntityCategories.Soldier) == 1 then
			if not EntitiesOutside[GetLeaderOfSoldier(Gate2Table[2])] then
				EntitiesOutside[GetLeaderOfSoldier(Gate2Table[2])] = {Type=Logic.GetEntityType(GetLeaderOfSoldier(Gate2Table[2])),Number=Logic.LeaderGetNumberOfSoldiers(GetLeaderOfSoldier(Gate2Table[2]))}
				DestroyEntity(GetLeaderOfSoldier(Gate2Table[2]))
			end
		else
			if Logic.IsEntityInCategory(Gate2Table[2], EntityCategories.Worker) == 0 then
				EntitiesOutside[Gate2Table[2]] = {Type=Logic.GetEntityType(Gate2Table[2])}
				DestroyEntity(Gate2Table[2])
			else
				DestroyEntity(Gate2Table[2])
			end
		end
		Gate2Table = {Logic.GetPlayerEntitiesInArea(1, nil, Gate2Pos.X, Gate2Pos.Y, 300, 16)}
	end
	while Gate3Table[1] > 0 do
		if Logic.IsLeader(Gate3Table[2]) == 1 then
			EntitiesOutside[Gate3Table[2]] = {Type=Logic.GetEntityType(Gate3Table[2]),Number=Logic.LeaderGetNumberOfSoldiers(Gate3Table[2])}
			DestroyEntity(Gate3Table[2])
		elseif Logic.IsEntityInCategory(Gate3Table[2],EntityCategories.Soldier) == 1 then
			if not EntitiesOutside[GetLeaderOfSoldier(Gate3Table[2])] then
				EntitiesOutside[GetLeaderOfSoldier(Gate3Table[2])] = {Type=Logic.GetEntityType(GetLeaderOfSoldier(Gate3Table[2])),Number=Logic.LeaderGetNumberOfSoldiers(GetLeaderOfSoldier(Gate3Table[2]))}
				DestroyEntity(GetLeaderOfSoldier(Gate3Table[2]))
			end
		else
			if Logic.IsEntityInCategory(Gate3Table[2], EntityCategories.Worker) == 0 then
				EntitiesOutside[Gate3Table[2]] = {Type=Logic.GetEntityType(Gate3Table[2])}
				DestroyEntity(Gate3Table[2])
			else
				DestroyEntity(Gate3Table[2])
			end
		end
		Gate3Table = {Logic.GetPlayerEntitiesInArea(1, nil, Gate3Pos.X, Gate3Pos.Y, 300, 16)}
	end
	ReplaceEntity(Gate1ID,Entities.XD_WallStraightGate_Closed)
	ReplaceEntity(Gate2ID,Entities.XD_WallStraightGate_Closed)
	ReplaceEntity(Gate3ID,Entities.XD_WallStraightGate_Closed)
	local OutsideSector = Logic.GetSector(GetID("EnemySpawn2"))
	for _id,_ in pairs(Player1Units) do
		local EntSector = Logic.GetSector(_id)
		if  EntSector == OutsideSector then	
			if Logic.IsLeader(_id) == 1 then
				EntitiesOutside[_id] = {Type=Logic.GetEntityType(_id),Number=Logic.LeaderGetNumberOfSoldiers(_id)}
				DestroyEntity(_id)
			elseif Logic.IsEntityInCategory(_id,EntityCategories.Soldier) == 1 then
				if not EntitiesOutside[GetLeaderOfSoldier(_id)] then
					EntitiesOutside[GetLeaderOfSoldier(_id)] = {Type=Logic.GetEntityType(GetLeaderOfSoldier(_id)),Number=Logic.LeaderGetNumberOfSoldiers(GetLeaderOfSoldier(_id))}
					DestroyEntity(GetLeaderOfSoldier(_id))
				end
			else
				if Logic.IsEntityInCategory(_id,EntityCategories.Worker) == 0 then
					EntitiesOutside[_id] = {Type=Logic.GetEntityType(_id)}
					DestroyEntity(_id)
				else
					DestroyEntity(_id)
				end
			end
			
		end
		
	end
	ReplaceEntity(Gate1ID,Entities.XD_WallStraightGate)
	ReplaceEntity(Gate2ID,Entities.XD_WallStraightGate)
	ReplaceEntity(Gate3ID,Entities.XD_WallStraightGate)
	
	CalcForCutscene()
end

function CalcForCutscene()
	_RemoveTable = {}
	local do_second;
	local _posTable;
	local _entID;
	local Movepos = GetPosition("FirstAttackSpawn1")
	for _id,_value in pairs(EntitiesOutside) do
		if Logic.IsEntityInCategory(_id, EntityCategories.Worker) == 0 then
			if not do_second then
				_posTable =  GetCirclePosition(Gate1Pos, 5000, math.random(25,85))
				if Logic.IsEntityTypeInCategory(_value.Type, EntityCategories.Leader) == 1 then
					_entID = Tools.CreateGroup(1, _value.Type, 8, _posTable.X, _posTable.Y,0 )
				else
					_entID = Logic.CreateEntity(_value.Type, _posTable.X, _posTable.Y, 0, 1)
				end
				table.insert(_RemoveTable,_entID)
				Move(_entID,Movepos)
			else
				_posTable =  GetCirclePosition(Gate3Pos, 3000, math.random(250,290))
				if Logic.IsEntityTypeInCategory(_value.Type, EntityCategories.Leader) == 1 then
					_entID = Tools.CreateGroup(1, _value.Type, 8, _posTable.X, _posTable.Y,0 )
				else
					_entID = Logic.CreateEntity(_value.Type, _posTable.X, _posTable.Y, 0, 1)
				end
				table.insert(_RemoveTable,_entID)
				Move(_entID,Movepos)
			end;
			do_second = not do_second;
		end			
	end;
	StartCutscene("ClosedDoors")
end

function P1EntityCreated()
	local id = Event.GetEntityID();
	local type = Logic.GetEntityType(id);
	if Logic.EntityGetPlayer(id) == 1 then
		if gvTypesToTrack[type] then
		   -- füge in liste ein
		Player1Units[id] = true;
		end;
	end
end

function P1EntityDestroied()
    local id = Event.GetEntityID();
    if Logic.EntityGetPlayer(id) == 1 then
        if Player1Units[id] then
            Player1Units[id] = nil;
        end;
    end
end

function P1BuildingCreated()
	local id = Event.GetEntityID();
	local _buildingtype = Logic.GetEntityType(id)
	if gvTypesToTrackBuildings[_buildingtype] then
		if Logic.EntityGetPlayer(id) == 1 then
			Player1Buildings[id] = true;
		end
	end
end

function P1BuildingDestroied()
	local id = Event.GetEntityID()
	if Logic.EntityGetPlayer(id) == 1 then
		if Player1Buildings[id] then
			Player1Buildings[id] = nil
		end
		if type(BuildingsOutside) == "table" then
			if BuildingsOutside[id] then
				BuildingsOutside[id] = nil
			end
		end
	end
end

function GetAllEntitiesOfPlayerOfType(_player, _type)
    local units = {};
    local n, first = Logic.GetPlayerEntities(_player, _type, 1);
    if n > 0 then
        local entity = first;
        repeat
            table.insert(units, entity)
            entity = Logic.GetNextEntityOfPlayerOfType(entity);
        until entity == first;
    end;
    
    return units;
end;